<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class RemoveSertifikatFromEducation extends Migration
{
    public function up()
    {
        // Check if column exists before dropping
        if ($this->db->fieldExists('sertifikat', 'education')) {
            $this->forge->dropColumn('education', 'sertifikat');
        }
    }

    public function down()
    {
        // Add back sertifikat column if needed to rollback
        $this->forge->addColumn('education', [
            'sertifikat' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => true,
                'after' => 'deskripsi'
            ]
        ]);
    }
}
